/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;

public class GHood
extends JApplet {
    public JLabel GHoodVersionLabel = new JLabel("GHood (18.01.2000)");
    public String GHoodInfo = "GHood graphical back-end for Hood\ncreated by C.Reinke\nhttp://www.cs.ukc.ac.uk/people/staff/cr3/\n\nHood library created by Andy Gill\nhttp://www.haskell.org/hood/";
    public BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    public String log = "<stdin>";
    public Map graph = Collections.synchronizedMap(new TreeMap());
    public Vector events = new Vector();
    public int eventCount = 0;
    public int eventNo = 0;
    public JLabel eventCountLabel = new JLabel("Events: " + Integer.toString(this.eventNo) + "/" + Integer.toString(this.eventCount));
    public int delay = 300;
    public int scale = 100;
    public JFrame frame;
    public GraphPanel panel;
    public JButton exitButton = new JButton("Exit");
    public JButton playButton = new JButton("Play");
    public JButton stepForwardButton = new JButton("Step >");
    public JButton stepBackwardButton = new JButton("Step <");
    public JButton resetButton = new JButton("Reset");
    public boolean play = true;
    public JButton stopButton = new JButton("Stop");
    public SwingWorker playWorker;
    public boolean playWorkerActive = false;
    public Container contentPane;

    public void init() {
        int n;
        String string = this.getParameter("eventSource");
        if (string != null) {
            this.log = string;
        }
        if ((string = this.getParameter("scale")) != null) {
            try {
                this.scale = n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("couldn't read scale parameter");
            }
        }
        if ((string = this.getParameter("delay")) != null) {
            try {
                this.delay = n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("couldn't read delay parameter");
            }
        }
        this.contentPane = this.getContentPane();
        this.setup();
        this.exitButton.setEnabled(false);
        this.setSize(new Dimension(500, 500));
        this.setVisible(true);
    }

    public void start() {
        if (this.log != null) {
            try {
                this.showStatus("reading " + this.log);
                this.in = new BufferedReader(new InputStreamReader(new URL(this.getDocumentBase(), this.log).openStream()));
                this.showStatus("read " + this.log);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(-1);
            }
        }
        this.playWorkerActive = true;
        this.playWorker = new SwingWorker(){

            public Object construct() {
                GHood.this.observeEvents();
                return null;
            }

            public void finished() {
                GHood.this.playWorkerActive = false;
                GHood.this.resetEvents();
                GHood.this.playButton.setEnabled(true);
                GHood.this.stepForwardButton.setEnabled(true);
                GHood.this.stepBackwardButton.setEnabled(true);
                GHood.this.resetButton.setEnabled(true);
            }
        };
        this.playWorker.start();
    }

    public void stop() {
        this.play = false;
    }

    public static void main(String[] stringArray) {
        final GHood gHood = new GHood();
        if (stringArray.length > 0) {
            try {
                gHood.in = new BufferedReader(new FileReader(stringArray[0]));
                gHood.log = stringArray[0];
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException);
                System.exit(-1);
            }
        }
        gHood.frame = new JFrame("GHood (" + gHood.log + ")");
        gHood.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        gHood.contentPane = gHood.frame.getContentPane();
        gHood.setup();
        gHood.frame.pack();
        gHood.frame.setSize(new Dimension(500, 500));
        gHood.frame.setVisible(true);
        gHood.playWorkerActive = true;
        gHood.playWorker = new SwingWorker(){

            public Object construct() {
                gHood.observeEvents();
                return null;
            }

            public void finished() {
                gHood.playWorkerActive = false;
                gHood.resetEvents();
                gHood.playButton.setEnabled(true);
                gHood.stepForwardButton.setEnabled(true);
                gHood.stepBackwardButton.setEnabled(true);
                gHood.resetButton.setEnabled(true);
            }
        };
        gHood.playWorker.start();
    }

    void setup() {
        Integer n = new Integer(0);
        this.graph.put(n, new Node(0, this.log));
        this.panel = new GraphPanel(this.graph, n);
        JScrollPane jScrollPane = new JScrollPane(this.panel);
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.exitButton.setToolTipText("Exit GHood Browser");
        JButton jButton = new JButton("Print");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PageFormat pageFormat = printerJob.pageDialog(printerJob.defaultPage());
                printerJob.setPrintable(GHood.this.panel, pageFormat);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        jButton.setToolTipText("Print current graph display");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GHood.this.stopButton.setEnabled(false);
                GHood.this.playButton.setEnabled(true);
                GHood.this.stepForwardButton.setEnabled(true);
                GHood.this.stepBackwardButton.setEnabled(true);
                GHood.this.resetButton.setEnabled(true);
                GHood.this.play = false;
                while (GHood.this.playWorkerActive) {
                }
                GHood.this.resetEvents();
            }
        });
        this.resetButton.setToolTipText("Reset animation");
        this.resetButton.setEnabled(false);
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GHood.this.stopButton.setEnabled(true);
                GHood.this.playButton.setEnabled(false);
                GHood.this.stepForwardButton.setEnabled(false);
                GHood.this.stepBackwardButton.setEnabled(false);
                GHood.this.resetButton.setEnabled(false);
                GHood.this.play = true;
                if (GHood.this.playWorkerActive) {
                    return;
                }
                GHood.this.playWorkerActive = true;
                GHood.this.playWorker = new SwingWorker(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object construct() {
                        7.access$000(this.this$1).playEvents(1);
                        7.access$000(this.this$1).stopButton.setEnabled(false);
                        7.access$000(this.this$1).resetButton.setEnabled(true);
                        7.access$000(this.this$1).play = false;
                        return null;
                    }

                    public void finished() {
                        7.access$000(this.this$1).playWorkerActive = false;
                    }
                };
                GHood.this.playWorker.start();
            }

            static /* synthetic */ GHood access$000(7 var0) {
                return var0.GHood.this;
            }
        });
        this.playButton.setToolTipText("Animate observations");
        this.playButton.setEnabled(false);
        this.stepForwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GHood.this.play = true;
                if (GHood.this.playWorkerActive) {
                    return;
                }
                GHood.this.playWorkerActive = true;
                GHood.this.playWorker = new SwingWorker(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object construct() {
                        9.access$100(this.this$1).stepEvents(1);
                        9.access$100(this.this$1).play = false;
                        return null;
                    }

                    public void finished() {
                        9.access$100(this.this$1).playWorkerActive = false;
                    }
                };
                GHood.this.playWorker.start();
            }

            static /* synthetic */ GHood access$100(9 var0) {
                return var0.GHood.this;
            }
        });
        this.stepForwardButton.setToolTipText("single-step forward");
        this.stepForwardButton.setEnabled(false);
        this.stepBackwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GHood.this.play = true;
                if (GHood.this.playWorkerActive) {
                    return;
                }
                GHood.this.playWorkerActive = true;
                GHood.this.playWorker = new SwingWorker(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object construct() {
                        11.access$200(this.this$1).stepEvents(-1);
                        11.access$200(this.this$1).play = false;
                        return null;
                    }

                    public void finished() {
                        11.access$200(this.this$1).playWorkerActive = false;
                    }
                };
                GHood.this.playWorker.start();
            }

            static /* synthetic */ GHood access$200(11 var0) {
                return var0.GHood.this;
            }
        });
        this.stepBackwardButton.setToolTipText("single-step backward");
        this.stepBackwardButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GHood.this.playButton.setEnabled(true);
                GHood.this.stepForwardButton.setEnabled(true);
                GHood.this.stepBackwardButton.setEnabled(true);
                GHood.this.resetButton.setEnabled(true);
                GHood.this.stopButton.setEnabled(false);
                GHood.this.play = false;
            }
        });
        this.stopButton.setToolTipText("Stop Animation");
        this.stopButton.setEnabled(false);
        JLabel jLabel = new JLabel("Delay");
        JSlider jSlider = new JSlider(0, 0, 1000, this.delay);
        jSlider.addChangeListener(new SliderListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    GHood.this.delay = jSlider.getValue();
                }
            }
        });
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("none"));
        hashtable.put(new Integer(500), new JLabel("0.5s/step"));
        hashtable.put(new Integer(1000), new JLabel("1s/step"));
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintLabels(true);
        JLabel jLabel2 = new JLabel("Scale");
        JSlider jSlider2 = new JSlider(0, 0, 200, this.scale);
        this.panel.sx = 0.01 * (double)this.scale;
        this.panel.sy = 0.01 * (double)this.scale;
        jSlider2.addChangeListener(new SliderListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    GHood.this.panel.sx = 0.01 * (double)jSlider.getValue();
                    GHood.this.panel.sy = 0.01 * (double)jSlider.getValue();
                    GHood.this.panel.repaint();
                }
            }
        });
        hashtable = new Hashtable();
        hashtable.put(new Integer(0), new JLabel("0%"));
        hashtable.put(new Integer(100), new JLabel("100%"));
        hashtable.put(new Integer(200), new JLabel("200%"));
        jSlider2.setLabelTable(hashtable);
        jSlider2.setPaintLabels(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.contentPane.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 100);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.GHoodVersionLabel, gridBagConstraints);
        this.contentPane.add(this.GHoodVersionLabel);
        this.GHoodVersionLabel.setToolTipText(this.GHoodInfo);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.eventCountLabel, gridBagConstraints);
        this.contentPane.add(this.eventCountLabel);
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.exitButton, gridBagConstraints);
        this.contentPane.add(this.exitButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.contentPane.add(jButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.resetButton, gridBagConstraints);
        this.contentPane.add(this.resetButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.playButton, gridBagConstraints);
        this.contentPane.add(this.playButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.stepForwardButton, gridBagConstraints);
        this.contentPane.add(this.stepForwardButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.stepBackwardButton, gridBagConstraints);
        this.contentPane.add(this.stepBackwardButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(this.stopButton, gridBagConstraints);
        this.contentPane.add(this.stopButton);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.contentPane.add(jLabel);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jSlider, gridBagConstraints);
        this.contentPane.add(jSlider);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.contentPane.add(jLabel2);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jSlider2, gridBagConstraints);
        this.contentPane.add(jSlider2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 7;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.contentPane.add(jScrollPane);
    }

    public void observeEvents() {
        this.events = new Vector();
        this.eventCount = 0;
        this.eventNo = 0;
        while (true) {
            String string;
            try {
                string = this.in.readLine();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                break;
            }
            if (string == null) break;
            ObserveEvent observeEvent = ObserveEvent.parse(string);
            if (observeEvent == null) continue;
            ++this.eventCount;
            this.eventCountLabel.setText("Events: " + Integer.toString(this.eventNo) + "/" + Integer.toString(this.eventCount));
            this.events.add(observeEvent);
            this.contentPane.repaint();
        }
    }

    public void resetEvents() {
        this.eventNo = 0;
        this.eventCountLabel.setText("Events: " + Integer.toString(this.eventNo) + "/" + Integer.toString(this.eventCount));
        Integer n = new Integer(0);
        this.graph = Collections.synchronizedMap(new TreeMap());
        this.graph.put(n, new Node(0, this.log));
        this.panel.reset(this.graph, n);
        this.contentPane.repaint();
    }

    public void playEvents(int n) {
        while (this.stepEvents(n)) {
        }
    }

    public boolean stepEvents(int n) {
        if (this.play && (n > 0 && this.eventNo < this.eventCount || n < 0 && this.eventNo > 0)) {
            ObserveEvent observeEvent;
            if (n > 0) {
                observeEvent = (ObserveEvent)this.events.elementAt(this.eventNo);
                this.eventNo += n;
            } else {
                this.eventNo += n;
                observeEvent = (ObserveEvent)this.events.elementAt(this.eventNo);
            }
            this.eventCountLabel.setText("Events: " + Integer.toString(this.eventNo) + "/" + Integer.toString(this.eventCount));
            if (n > 0) {
                observeEvent.registerIn(this.graph);
            } else {
                observeEvent.unRegisterIn(this.graph);
            }
            this.contentPane.repaint();
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            return true;
        }
        return false;
    }
}

