/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;

class RootedGraph {
    Node root;
    public double originX = 50.0;
    public double originY = 50.0;
    public double farX;
    public double farY;
    FontMetrics fm;
    int fmHeight;
    Color fg = Color.black;
    Color fg3D = Color.lightGray;

    public RootedGraph(Node node) {
        this.root = node;
    }

    void layoutNodeGraph(Outline outline, double d, int n, Node node) {
        Boolean bl = node.locked;
        synchronized (bl) {
            node.locked = new Boolean(true);
        }
        outline.reset(n, this.leftDepth(node));
        double d2 = outline.get(n);
        double d3 = d;
        Enumeration enumeration = node.outs.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            this.layoutNodeGraph(outline, d + 30.0 + (double)this.fmHeight, n + 1, edge.target);
        }
        outline.set(n, d2 + 20.0 + (double)this.fm.stringWidth(node.label));
        node.x = d2;
        this.farX = Math.max(d2, this.farX);
        node.y = d3;
        this.farY = Math.max(d3, this.farY);
        node.layedOut = true;
    }

    int leftDepth(Node node) {
        Node node2 = node;
        int n = 0;
        while (node2.outs.size() > 0) {
            ++n;
            node2 = ((Edge)node2.outs.elementAt((int)0)).target;
        }
        return n;
    }

    void drawNode(Graphics2D graphics2D, Node node) {
        Rectangle2D rectangle2D = this.fm.getStringBounds(node.label, graphics2D);
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        graphics2D.setColor(this.fg3D);
        graphics2D.draw3DRect((int)node.x - 5, (int)node.y - n2, n + 10, n2 + 5, true);
        graphics2D.setColor(node.color);
        graphics2D.drawString(node.label, (int)node.x, (int)node.y);
        graphics2D.setColor(this.fg);
    }

    void drawEdge(Graphics2D graphics2D, Node node, Node node2, Color color) {
        graphics2D.drawLine((int)node.x, (int)node.y + 5, (int)node2.x, (int)node2.y - this.fmHeight);
    }

    void drawNodeGraph(Graphics2D graphics2D, Node node) {
        Object object;
        Object object2;
        this.drawNode(graphics2D, node);
        Enumeration enumeration = node.outs.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Edge)enumeration.nextElement();
            object = ((Edge)object2).target;
            this.drawEdge(graphics2D, node, (Node)object, ((Edge)object2).color);
            this.drawNodeGraph(graphics2D, (Node)object);
        }
        object2 = node.locked;
        synchronized (object2) {
            object = node.locked;
            node.locked = new Boolean(false);
            object.notifyAll();
        }
    }

    public void draw(Graphics2D graphics2D) {
        this.fm = graphics2D.getFontMetrics();
        this.fmHeight = this.fm.getHeight();
        this.farX = this.originX;
        this.farY = this.originY;
        this.layoutNodeGraph(new Outline(this.originX), this.originY, 0, this.root);
        this.drawNodeGraph(graphics2D, this.root);
    }
}

